<?php

/**
 * A super-simple user-authentication solution, embedded into a small framework.
 *
 * HUGE
 *
 * @link https://github.com/panique/huge
 * @license http://opensource.org/licenses/MIT MIT License
 */

// auto-loading the classes (currently only from application/libs) via Composer's PSR-4 auto-loader
// later it might be useful to use a namespace here, but for now let's keep it as simple as possible
//require '../core/autoload.php';
   // Example to auto-load class files from multiple directories using the SPL_AUTOLOAD_REGISTER method.
    // It auto-loads any file it finds starting with class.<classname>.php (LOWERCASE), eg: class.from.php, class.db.php
    spl_autoload_register(function($class_name) {

        // Define an array of directories in the order of their priority to iterate through.
        $dirs = array(
            '../application/core/', // Project specific classes (+Core Overrides)
            '../application/model/', // Core classes example
            //'tests/',   // Unit test classes, if using PHP-Unit
        );

        // Looping through each directory to load all the class files. It will only require a file once.
        // If it finds the same class in a directory later on, IT WILL IGNORE IT! Because of that require once!
        foreach( $dirs as $dir ) {
            if (file_exists($dir.$class_name.'.php')) {
                require_once($dir.$class_name.'.php');
                return;
            }
        }
        //require('../application/aws.phar');
    });

     //$s3 = S3Client::factory();
     //echo  $_SERVER['DOCUMENT_ROOT'];
     // Get an object.

    //print_r(UtilityModel::testDB('_hms'));

// start our application
new Application();